@ECHO OFF

SETLOCAL ENABLEDELAYEDEXPANSION

REM Check if Reg.exe exists
IF NOT EXIST %SystemRoot%\system32\reg.exe GOTO ErrorReg

REM Get Tools install path from registry
IF "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
FOR /F "tokens=2* delims=	, " %%A IN ('REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Windows Embedded" /v InstallDir') DO SET INSTALLDIR=%%B
) ELSE (
FOR /F "tokens=2* delims=	, " %%A IN ('REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows Embedded" /v InstallDir') DO SET INSTALLDIR=%%B
)

IF  "%INSTALLDIR%"=="" GOTO ErrorTools
SET TARGETDIR=%INSTALLDIR%

REM Remove trailing backslash from registry key
if "!TARGETDIR:~-1!"=="\" set TARGETDIR=!TARGETDIR:~0,-1!

REM Check to ensure the script was provided the source location for the help docs
IF "%1"=="" (
ECHO The source location for the files was not provided.  Using the current directory instead.
ECHO.
set SOURCEDIR=.
) ELSE (
set SOURCEDIR=%1
)

REM Check if %ProgramFiles%\FBWFAPI exist
REM If so backup
IF EXIST "%TARGETDIR%"\FBWFAPI goto CheckForOldDirectory

goto CreateAPIDirectory

:CheckForOldDirectory
IF EXIST "%TARGETDIR%"\FBWFAPI.OLD goto ClearDirectory

goto BackupDirectory

:ClearDirectory
rmdir /s/q "%TARGETDIR%"\FBWFAPI.OLD

:BackupDirectory
move "%TARGETDIR%"\FBWFAPI "%TARGETDIR%"\FBWFAPI.OLD

:CreateAPIDirectory
mkdir "%TARGETDIR%"\FBWFAPI

REM Copy the new api files
COPY "%SOURCEDIR%"\fbwfapi.h "%TARGETDIR%"\FBWFAPI\fbwfapi.h /v /y
COPY "%SOURCEDIR%"\fbwflib.lib "%TARGETDIR%"\FBWFAPI\fbwflib.lib /v /y

ECHO Success: The Header and Library files have been copied to %TARGETDIR%\FBWFAPI
goto Done

:ErrorReg
ECHO Error: This update requires Reg.exe to be present in %systemroot%\system32 folder.
GOTO Done

:ErrorTools
ECHO Error: This update can be installed only if you have Windows XP Embedded Tools installed.

:Done

PAUSE
