@ECHO OFF

REM Check if Reg.exe exists
IF NOT EXIST %SystemRoot%\system32\reg.exe GOTO ErrorReg

REM Get Tools install path from registry
IF "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
FOR /F "tokens=2* delims=	, " %%A IN ('REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Windows Embedded" /v InstallDir') DO SET INSTALLDIR=%%B
) ELSE (
FOR /F "tokens=2* delims=	, " %%A IN ('REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows Embedded" /v InstallDir') DO SET INSTALLDIR=%%B
)

REM Verify that querying the registry succeeded
IF  "%INSTALLDIR%"=="" GOTO ErrorTools
SET TARGETDIR=%INSTALLDIR%help

REM Check to ensure the script was provided the source location for the help docs
IF "%1"=="" (
ECHO The source location for the help files was not provided.  Using the current directory instead.
ECHO.
set SOURCEDIR=.
) ELSE (
set SOURCEDIR=%1
)

REM Display a warning message to close all embedded studio tools.
ECHO Please close all instances of Windows XP Embedded Tools before continuing this installation.
PAUSE

REM Copy the new CHMs to the help directory
XCOPY %SOURCEDIR%\wecommon.chm "%TARGETDIR%"\weshared.chm /v /y
XCOPY %SOURCEDIR%\wecommon.chm "%TARGETDIR%"\targdsn.chm /v /y
XCOPY %SOURCEDIR%\wecommon.chm "%TARGETDIR%"\compdsn.chm /v /y
XCOPY %SOURCEDIR%\wecommon.chm "%TARGETDIR%"\cdbmgr.chm /v /y
XCOPY %SOURCEDIR%\wecommon.chm "%TARGETDIR%"\westudio.chm /v /y
XCOPY %SOURCEDIR%\install.chm "%TARGETDIR%" /v /y
XCOPY %SOURCEDIR%\xpehelp.chm "%TARGETDIR%" /v /y
XCOPY %SOURCEDIR%\comphelp.chm "%TARGETDIR%" /v /y
XCOPY %SOURCEDIR%\comphelp.dat "%TARGETDIR%" /v /y
GOTO Done

:ErrorReg
ECHO Error: This update requires Reg.exe to be present in %systemroot%\system32 folder.
GOTO Done

:ErrorTools
ECHO Error: This update can be installed only if you have Windows XP Embedded Tools installed.

:Done

PAUSE